/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.lasers.model.mirror.PartialMirror;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class MirrorGraphic
extends PhetGraphic
implements PartialMirror.Listener {
    private PartialMirror mirror;
    Rectangle bounds = new Rectangle();
    private Ellipse2D face1;
    private Ellipse2D face2;
    private Rectangle2D body;
    private Line2D upperLine;
    private Line2D lowerLine;
    private Paint mirrorPaint1;
    private Paint mirrorPaint2;
    private Point2D.Double p1;
    private Point2D.Double p2;
    private double xOffset;
    private BufferedImage mirrorBI;
    private float outlineStrokeWidth = 1.0f;
    private Stroke outlineStroke = new BasicStroke(this.outlineStrokeWidth);
    private Color mirrorColor = new Color(180, 180, 180);

    public MirrorGraphic(Component component, PartialMirror partialMirror, int n) {
        super(component);
        this.mirror = partialMirror;
        switch (n) {
            case 1: {
                this.xOffset = 0.0;
                break;
            }
            case 2: {
                this.xOffset = -15.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid direction specified in constructor");
            }
        }
        partialMirror.addListener(this);
        this.update(partialMirror.getReflectivity());
    }

    protected Rectangle determineBounds() {
        return this.bounds;
    }

    public void reflectivityChanged(PartialMirror.ReflectivityChangedEvent reflectivityChangedEvent) {
        this.update(reflectivityChangedEvent.getReflectivity());
    }

    private void update(double d) {
        int n = 100;
        int n2 = 220;
        int n3 = n2 - (int)(d * (double)(n2 - n));
        this.mirrorColor = new Color(n3, n3, n3);
        this.bounds.setFrame((int)(this.mirror.getPosition().getX() - 15.0 + this.xOffset), (int)this.mirror.getPosition().getY(), 30.0 + (double)this.outlineStrokeWidth, this.mirror.getBounds().getHeight());
        this.face1 = new Ellipse2D.Double(15.0, 0.0, 15.0, this.bounds.getHeight());
        this.face2 = new Ellipse2D.Double(0.0, 0.0, 15.0, this.bounds.getHeight());
        this.body = new Rectangle2D.Double(7.5, 0.0, 15.0, this.bounds.getHeight());
        this.upperLine = new Line2D.Double(7.5, 0.0, 22.5, 0.0);
        this.lowerLine = new Line2D.Double(7.5, this.bounds.getHeight(), 22.5, this.bounds.getHeight());
        this.p1 = new Point2D.Double(3.75, this.bounds.getHeight() / 2.0 - 0.5);
        this.p2 = new Point2D.Double(7.5, this.bounds.getHeight() / 2.0);
        this.mirrorPaint1 = new GradientPaint(this.p1, this.mirrorColor, this.p2, new Color(0, 0, 0, 0), false);
        Point2D.Double double_ = new Point2D.Double(7.5, this.bounds.getHeight() / 2.0);
        Point2D.Double double_2 = new Point2D.Double(11.25, this.bounds.getHeight() / 2.0 + 0.5);
        this.mirrorPaint2 = new GradientPaint(double_, new Color(0, 0, 0, 0), double_2, this.mirrorColor, false);
        this.mirrorBI = new BufferedImage((int)this.bounds.getWidth(), (int)(this.bounds.getHeight() + (double)this.outlineStrokeWidth), 3);
        Graphics2D graphics2D = (Graphics2D)this.mirrorBI.getGraphics();
        GraphicsUtil.setAntiAliasingOn(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setColor(this.mirrorColor);
        graphics2D.setStroke(this.outlineStroke);
        graphics2D.fill(this.face1);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.face1);
        graphics2D.setColor(this.mirrorColor);
        graphics2D.fill(this.body);
        graphics2D.setPaint(Color.white);
        graphics2D.fill(this.face2);
        graphics2D.setPaint(this.mirrorPaint1);
        graphics2D.fill(this.face2);
        graphics2D.setPaint(this.mirrorPaint2);
        graphics2D.fill(this.face2);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.face2);
        graphics2D.draw(this.upperLine);
        graphics2D.draw(this.lowerLine);
        this.setBoundsDirty();
        this.repaint();
    }

    public void paint(Graphics2D graphics2D) {
        this.saveGraphicsState(graphics2D);
        graphics2D.drawImage((Image)this.mirrorBI, (int)(this.mirror.getPosition().getX() - 7.5 + this.xOffset), (int)this.mirror.getPosition().getY(), null);
        this.restoreGraphicsState();
    }
}

